/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Evacuee {
    private static double agilityprobability;
    private static double patienceprobability;
    private static int originalSize;
    private int diameter;
    private MyVector position;
    private MyVector movement;
    private double speed;
    private double originalSpeed;
    private boolean free;
    private int impatience;
    private boolean aggresive;

    public Evacuee(double x, double y, double SPEED) {
        this.position = new MyVector(x, y);
        this.diameter = originalSize = 15;
        agilityprobability = 0.75;
        patienceprobability = 0.5;
        this.aggresive = false;
        this.impatience = 0;
        this.speed = SPEED;
        this.originalSpeed = SPEED;
    }

    public MyVector getPosition() {
        return this.position;
    }

    public MyVector lookAhead() {
        return MyVector.getSum(this.position, this.movement.normalize().multiplyBy(this.speed));
    }

    public void moveEvacuee() {
        this.position = MyVector.getSum(this.position, this.movement.normalize().multiplyBy(this.speed));
    }

    public int getSize() {
        return this.diameter;
    }

    public void setSize(int size) {
        this.diameter = size;
    }

    public void resetSize() {
        this.diameter = originalSize;
    }

    public static int getOriginalSize() {
        return originalSize;
    }

    public void setfree(boolean A) {
        this.free = A;
    }

    public boolean free() {
        return this.free;
    }

    public boolean getAggresion() {
        return this.aggresive;
    }

    public void notAggresive() {
        this.aggresive = false;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double sp) {
        this.speed = sp;
    }

    public void resetSpeed() {
        this.speed = this.originalSpeed + 1.0;
    }

    public void setMovement(MyVector s) {
        this.movement = s;
    }

    public MyVector getMove() {
        return this.movement;
    }

    public void impatience(int length, int doorsize) {
        if (this.movement.getx() == 0.0 && this.movement.gety() == 0.0) {
            ++this.impatience;
        } else {
            this.impatience = 0;
            this.resetSize();
        }
        if (this.impatience > 10 && this.diameter > 13) {
            this.diameter = this.getSize() - 1;
        }
        if (this.impatience > 30 && this.position.gety() > (double)(length / 2 - doorsize / 2) && this.position.gety() < (double)(length / 2 + doorsize / 2) && this.position.getx() < 20.0) {
            this.diameter = this.getSize() - 1;
            this.aggresive = true;
            this.moveEvacuee();
        }
    }

    public static Evacuee[] scrambleArray(Evacuee[] myArray) {
        Random rnd = new Random();
        int i = myArray.length - 1;
        while (i > 0) {
            int index = rnd.nextInt(i + 1);
            Evacuee a = myArray[index];
            myArray[index] = myArray[i];
            myArray[i] = a;
            --i;
        }
        return myArray;
    }

    public static boolean evacueeCollision(Evacuee A, Evacuee B) {
        boolean result = false;
        if (MyVector.getDifference(A.lookAhead(), B.getPosition()).getmagnitude() < (double)(A.getSize() / 2 + B.getSize() / 2 + 1)) {
            result = true;
        }
        return result;
    }

    public static boolean plantingCollision(Evacuee A, Evacuee B) {
        boolean result = false;
        if (MyVector.getDifference(A.getPosition(), B.getPosition()).getmagnitude() < (double)(A.getSize() / 2 + B.getSize() / 2 + 1)) {
            result = true;
        }
        return result;
    }

    public void moveBack() {
        this.movement = this.movement.rotation(180);
    }

    public void moveRight() {
        this.movement = this.movement.rotation(270);
    }

    public void moveLeft() {
        this.movement = this.movement.rotation(90);
    }

    public static boolean anyColliders(int person, Evacuee[] myEvacuees) {
        boolean result = false;
        int neighbour = 0;
        while (neighbour < myEvacuees.length) {
            if (neighbour != person && myEvacuees[neighbour] != null && Evacuee.evacueeCollision(myEvacuees[person], myEvacuees[neighbour])) {
                result = true;
            }
            ++neighbour;
        }
        return result;
    }

    public static void bounceOfWall(int person, Evacuee[] myEvacuees, int myydimension) {
        if (myEvacuees[person].getPosition().gety() > (double)(myydimension / 2)) {
            myEvacuees[person].moveRight();
        } else {
            myEvacuees[person].moveLeft();
        }
        if (Evacuee.anyColliders(person, myEvacuees)) {
            myEvacuees[person].setMovement(new MyVector(0.0, 0.0));
        }
    }

    public static void collisionDecision(int person, Evacuee[] myEvacuees) {
        MyVector originalMove = myEvacuees[person].getMove();
        if (Math.random() * 100.0 < agilityprobability * 100.0 && myEvacuees[person].getPosition().getx() > 0.0) {
            myEvacuees[person].moveRight();
        }
        if (Evacuee.anyColliders(person, myEvacuees)) {
            myEvacuees[person].setMovement(originalMove);
            if (Math.random() * 100.0 < agilityprobability * 100.0 && myEvacuees[person].getPosition().getx() > 0.0) {
                myEvacuees[person].moveLeft();
            }
            if (Evacuee.anyColliders(person, myEvacuees)) {
                myEvacuees[person].setMovement(originalMove);
                if (Math.random() * 100.0 < patienceprobability * 100.0) {
                    myEvacuees[person].moveBack();
                }
                if (Evacuee.anyColliders(person, myEvacuees)) {
                    myEvacuees[person].setMovement(new MyVector(0.0, 0.0));
                }
            }
        }
    }
}

