/*
 * Decompiled with CFR 0.152.
 */
public class MyVector {
    private double x;
    private double y;

    public MyVector(double myX, double myY) {
        this.x = myX;
        this.y = myY;
    }

    public double getx() {
        return this.x;
    }

    public double gety() {
        return this.y;
    }

    public MyVector rotation(int angle) {
        double xnew = this.x * Math.cos(Math.PI * (double)angle / 180.0) + this.y * Math.sin(Math.PI * (double)angle / 180.0);
        double ynew = this.y * Math.cos(Math.PI * (double)angle / 180.0) - this.x * Math.sin(Math.PI * (double)angle / 180.0);
        return new MyVector(xnew, ynew);
    }

    public MyVector normalize() {
        double xnew = 0.0;
        double ynew = 0.0;
        if (this.x != 0.0 && this.y != 0.0) {
            xnew = this.x / Math.sqrt(this.x * this.x + this.y * this.y);
            ynew = this.y / Math.sqrt(this.x * this.x + this.y * this.y);
        }
        return new MyVector(xnew, ynew);
    }

    public double getmagnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static MyVector getDifference(MyVector A, MyVector B) {
        return new MyVector(A.getx() - B.getx(), A.gety() - B.gety());
    }

    public static MyVector getSum(MyVector A, MyVector B) {
        return new MyVector(A.getx() + B.getx(), A.gety() + B.gety());
    }

    public MyVector multiplyBy(double f) {
        return new MyVector(this.x * f, this.y * f);
    }
}

