/*
 * Decompiled with CFR 0.152.
 */
public class Room {
    private int xdimension;
    private int ydimension;
    private int doorSize;
    private int numberOfEvacuees;
    private Evacuee[] myEvacuee;
    private Wall myWall;
    private boolean allFree;

    public Room(int doorsize, int noPeople, double SPEED) {
        this.doorSize = doorsize;
        this.numberOfEvacuees = noPeople;
        this.ydimension = 500;
        this.xdimension = 500;
        this.myEvacuee = new Evacuee[this.numberOfEvacuees];
        this.myWall = new Wall(this.xdimension, this.ydimension, this.doorSize);
        this.fillRoom(SPEED);
    }

    public int getxdimension() {
        return this.xdimension;
    }

    public int getydimension() {
        return this.ydimension;
    }

    public int getDoorSize() {
        return this.doorSize;
    }

    public Wall getWall() {
        return this.myWall;
    }

    public Evacuee[] getEvacuees() {
        return this.myEvacuee;
    }

    public Evacuee getEvacuee(int i) {
        return this.myEvacuee[i];
    }

    public boolean getAllFree() {
        return this.allFree;
    }

    private void fillRoom(double SPEED) {
        int thisguy = 0;
        while (thisguy < this.numberOfEvacuees) {
            double posX = (double)(Evacuee.getOriginalSize() / 2) + Math.random() * (double)(this.xdimension - Evacuee.getOriginalSize());
            double posY = (double)(Evacuee.getOriginalSize() / 2) + Math.random() * (double)(this.ydimension - Evacuee.getOriginalSize());
            this.myEvacuee[thisguy] = new Evacuee(posX, posY, SPEED);
            if (thisguy != 0) {
                int neighbours = 0;
                while (neighbours <= thisguy - 1) {
                    if (Evacuee.plantingCollision(this.myEvacuee[thisguy], this.myEvacuee[neighbours])) {
                        --thisguy;
                    }
                    ++neighbours;
                }
            }
            ++thisguy;
        }
    }

    public void whereIsTheDoor(int person) {
        int m = (int)Math.floor(Math.random() * (double)(this.doorSize - this.myEvacuee[person].getSize()));
        MyVector point = new MyVector(-10.0, this.ydimension / 2 - this.doorSize / 2 + this.myEvacuee[person].getSize() / 2 + m);
        this.myEvacuee[person].setMovement(MyVector.getDifference(point, this.myEvacuee[person].getPosition()));
    }

    public void hitWall(int person) {
        if ((!(this.myEvacuee[person].getPosition().gety() > (double)(this.ydimension / 2 - this.doorSize / 2 + this.myEvacuee[person].getSize() / 2)) || !(this.myEvacuee[person].getPosition().gety() < (double)(this.ydimension / 2 + this.doorSize / 2 - this.myEvacuee[person].getSize() / 2 - 2))) && (this.myEvacuee[person].lookAhead().getx() < (double)(this.myEvacuee[person].getSize() / 2) || this.myEvacuee[person].lookAhead().getx() > (double)(this.xdimension - this.myEvacuee[person].getSize() / 2) || this.myEvacuee[person].lookAhead().gety() < (double)(this.myEvacuee[person].getSize() / 2) || this.myEvacuee[person].lookAhead().gety() > (double)(this.ydimension - this.myEvacuee[person].getSize() / 2))) {
            Evacuee.bounceOfWall(person, this.myEvacuee, this.ydimension);
        }
    }

    public void HaveIHitEvacuee(int person) {
        if (Evacuee.anyColliders(person, this.myEvacuee)) {
            Evacuee.collisionDecision(person, this.myEvacuee);
        }
    }

    public void move() {
        Evacuee.scrambleArray(this.myEvacuee);
        int count = 0;
        int thisguy = 0;
        while (thisguy < this.myEvacuee.length) {
            if (this.myEvacuee[thisguy] != null) {
                this.whereIsTheDoor(thisguy);
                this.myEvacuee[thisguy].resetSpeed();
                do {
                    this.myEvacuee[thisguy].setSpeed(this.myEvacuee[thisguy].getSpeed() - 1.0);
                    this.HaveIHitEvacuee(thisguy);
                    this.hitWall(thisguy);
                } while (this.myEvacuee[thisguy].getMove().getx() == 0.0 && this.myEvacuee[thisguy].getMove().gety() == 0.0 && this.myEvacuee[thisguy].getSpeed() > 1.0);
                this.myEvacuee[thisguy].impatience(this.ydimension, this.doorSize);
                this.myEvacuee[thisguy].moveEvacuee();
                if (this.myEvacuee[thisguy].getPosition().getx() < -5.0) {
                    this.myEvacuee[thisguy] = null;
                }
            } else {
                ++count;
            }
            ++thisguy;
        }
        if (count == this.numberOfEvacuees) {
            this.allFree = true;
        }
    }
}

